//
//  GSLayer+MetricsKeysUI.h
//  GlyphsCore
//
//  Created by Georg Seifert on 31.08.15.
//  Copyright (c) 2015 schriftgestaltung.de. All rights reserved.
//

#import <GlyphsCore/GSLayer.h>

/**
 States of metrics keys
 */

typedef NS_OPTIONS(uint8_t, GSMetricsKeysUI) {
	GSMetricsKeysOK = 0,
	GSMetricsKeysOutOfSync = 1 << 0,
	GSMetricsKeysInvalid = 1 << 1,
	GSMetricsKeysPlaceholder = 1 << 2,
};

NS_ASSUME_NONNULL_BEGIN

@interface GSLayer (MetricsKeysUI)

+ (NSInteger)alignedMetricsValueForKey:(NSString *)key;

- (BOOL)metricsKeysOutOfSync;

- (BOOL)metricsKeysInvalid;

- (NSString *)plainMetricsKeyUI:(GSMetricNumbers)side;

+ (NSColor *)colorForMetricsState:(GSMetricsKeysUI)state;

#pragma mark Left
@property (nonatomic, unsafe_unretained, nullable) NSString *leftMetricsKeyUI;
- (GSMetricsKeysUI)leftMetricsKeyState;
- (NSString *)leftMetricsKeyState:(nullable GSMetricsKeysUI *)state;
- (NSString *)leftPlainMetricsKey;

#pragma mark Width
@property (nonatomic, unsafe_unretained, nullable) NSString *widthMetricsKeyUI;
- (NSString *)widthMetricsKeyUIFast;
- (GSMetricsKeysUI)widthMetricsKeyState;
- (NSString *)widthMetricsKeyState:(nullable GSMetricsKeysUI *)state;
- (NSString *)widthPlainMetricsKey;

#pragma mark Right
@property (nonatomic, unsafe_unretained, nullable) NSString *rightMetricsKeyUI;
- (GSMetricsKeysUI)rightMetricsKeyState;
- (NSString *)rightMetricsKeyState:(nullable GSMetricsKeysUI *)state;
- (NSString *)rightPlainMetricsKey;

#pragma mark Top
@property (nonatomic, unsafe_unretained, nullable) NSString *topMetricsKeyUI;
- (GSMetricsKeysUI)topMetricsKeyState;
- (NSString *)topMetricsKeyState:(nullable GSMetricsKeysUI *)state;
- (NSString *)topPlainMetricsKey;

#pragma mark Bottom
@property (nonatomic, unsafe_unretained, nullable) NSString *bottomMetricsKeyUI;
- (GSMetricsKeysUI)bottomMetricsKeyState;
- (NSString *)bottomMetricsKeyState:(nullable GSMetricsKeysUI *)state;
- (NSString *)bottomPlainMetricsKey;

#pragma mark Vert Width
- (CGFloat)vertWidthUI;
@property (nonatomic, unsafe_unretained, nullable) NSString *vertWidthMetricsKeyUI;
- (GSMetricsKeysUI)vertWidthMetricsKeyState;
- (NSString *)vertWidthMetricsKeyState:(nullable GSMetricsKeysUI *)state defaultKey:(nullable NSString *)defaultKey;
- (NSString *)vertWidthPlainMetricsKey;

#pragma mark Vert Origin
@property (nonatomic, unsafe_unretained, nullable) NSString *vertOriginMetricsKeyUI;
- (GSMetricsKeysUI)vertOriginMetricsKeyState;
- (NSString *)vertOriginMetricsKeyState:(nullable GSMetricsKeysUI *)state;
- (NSString *)vertOriginPlainMetricsKey;

@end

NS_ASSUME_NONNULL_END
